<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_ProfilePost extends XFCP_sonnbStopSpamHere_ControllerPublic_ProfilePost
{
	public function actionMarkSpam()
	{
		$profilePostId = $this->_input->filterSingle('profile_post_id', XenForo_Input::UINT);
		list($profilePost, $user) = $this->getHelper('UserProfile')->assertProfilePostValidAndViewable($profilePostId);
		
		if ($this->isConfirmedPost())
		{
			$profilePostDw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_ProfilePost');
			$profilePostDw->setExistingData($profilePost['profile_post_id']);
			$profilePostDw->set('message_state', 'moderated');
			$profilePostDw->save();
				
			return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					XenForo_link::buildPublicLink('members', $user),
					new XenForo_Phrase('sonnbStopSpamHere_thank_you_that_post_was_sent_to_moderator')
			);
		}
		else
		{
			/*
			 * Show form to user to confirm that they are really want to mark this post as spam
			*/
			return $this->responseView(
					'sonnbStopSpamHere_ViewPublic_ProfilePost_MarkSpam',
					'sonnbStopSpamHere_confirm_mark_spam_profilePost',
					array(
						'profilePost' => $profilePost,
						'user' => $user
					)
			);
		}
	}
	
    public function actionComment()
    {
        $message = $this->getHelper('Editor')->getMessageText('message', $this->_input);
        $sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
        
        if ($sshModel->_hasLinkCheck('profile_post_reply'))
        {
            $return = $sshModel->checkLink(sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST_COMMENT, 0, $message);

            if ($return)
            {                
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_LINK,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('link', array(
                            'post'=> $sshModel->options->sonnbStopSpamHere_linkDisabledPostCount, 
                            'day'=> $sshModel->options->sonnbStopSpamHere_linkDisabledJoinDate
                        ));
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report':
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_COMMENT_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        if ($sshModel->_hasKeywordCheck('profile_post_reply'))
        {
            $return = $sshModel->checkKeyword(sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST_COMMENT, 0, $message);

            if ($return)
            {                
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_KEYWORD,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('keyword', array(
                            'keywords'=>implode('","', $return['data']['matches'])
                        ));
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report':
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_COMMENT_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }

        if ($sshModel->_hasAkismetCheck('profile_post_reply'))
        {
            $return = $sshModel->checkAkismet(sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST_COMMENT, 0, $message);
            
            if ($return)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_AKISMET,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError();
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report':
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_COMMENT_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        return parent::actionComment();
    }
    
    public function throwError($type='default', $data = array())
    {
        $params = array();
        switch ($type)
        {
            case 'link':
                $params = $data;
                if (empty($params['post']) && !empty($params['day']))
                {
                    $type .= '_day';
                }
                elseif (empty($params['day']) && !empty($params['post']))
                {
                    $type .= '_post';
                }
                elseif (empty($params['day']) && empty($params['post']))
                {
                    $type .= '_no_reason';
                }
                break;
            case 'keyword':
                $params = $data;
                break;
            case 'default':
            default:
                $params = array('contactUrl' => sonnbStopSpamHere_Model_Log::getContactUrl());
                break;
        }
        
        throw $this->responseException(
                $this->responseError(
                        new XenForo_Phrase(
                                'sonnbStopSpamHere_post_stop_message_'.$type,
                                $params
                            )
                        , 403)
                );
    }

}